package com.pragprog.aebook.hellochat.client;

import com.pragprog.aebook.hellochat.shared.FieldVerifier;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Klasy punktu wejścia definiują metodę <code>onModuleLoad</code>.
 */
public class Czat_powitalny implements EntryPoint {
	/**
	 * Wiadomość niżej jest wyświetlana, gdy klient nie może nawiązać połączenia z serwerem
	 * i zwraca błąd.
	 */
	private static final String SERVER_ERROR = "Przy próbie kontaktu z serwerem "
			+ "doszło do błędu. Sprawdź stan połączenia z internetem "
			+ "i spróbuj ponownie.";

	/**
	 * Tworzymy zdalne proxy usług, by komunikować się z usługą Greeting.
	 */
	private final GreetingServiceAsync greetingService = GWT
			.create(GreetingService.class);

	/**
	 * To jest metoda wejścia.
	 */
	public void onModuleLoad() {
		final Button sendButton = new Button("Wyślij");
		final TextBox nameField = new TextBox();
		nameField.setText("Użytkownik GWT");
		final Label errorLabel = new Label();

		// Dodajemy nazwę selektora klasy do komponentu
		sendButton.addStyleName("sendButton");

		// Dodajemy pole wpisów "nameField" do strony
		// Polecenie RootPanel.get() pozwala nam pobrać zawartość całego znacznika <body w HTML
		RootPanel.get("nameFieldContainer").add(nameField);
		RootPanel.get("sendButtonContainer").add(sendButton);
		RootPanel.get("errorLabelContainer").add(errorLabel);

		// Nadajemy polu wpisów właściwość focus
		nameField.setFocus(true);
		nameField.selectAll();

		// Tworzymy wyskakujące okienko dialogowe
		final DialogBox dialogBox = new DialogBox();
		dialogBox.setText("RPC - zdalne wywołanie procedury");
		dialogBox.setAnimationEnabled(true);
		final Button closeButton = new Button("Zamknij");
		// Uzyskując dostęp do dowolnego elementu HTML, możemy mu nadać atrybut id
		closeButton.getElement().setId("closeButton");
		final Label textToServerLabel = new Label();
		final HTML serverResponseLabel = new HTML();
		VerticalPanel dialogVPanel = new VerticalPanel();
		dialogVPanel.addStyleName("dialogVPanel");
		dialogVPanel.add(new HTML("<b>Wysłany na serwer nick:</b>"));
		dialogVPanel.add(textToServerLabel);
		dialogVPanel.add(new HTML("<br><b>Odpowiedź serwera:</b>"));
		dialogVPanel.add(serverResponseLabel);
		dialogVPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);
		dialogVPanel.add(closeButton);
		dialogBox.setWidget(dialogVPanel);

		// Do okna dialogBox załączamy funkcję obsługującą zdarzenie "Click"
		closeButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				sendButton.setEnabled(true);
				sendButton.setFocus(true);
			}
		});

		// Create a handler for the sendButton and nameField
		class MyHandler implements ClickHandler, KeyUpHandler {
			/** Uruchamiany po kliknięciu przez użytkownika przycisku sendButton. */
			public void onClick(ClickEvent event) {
				sendNameToServer();
			}

			/** Uruchamiany po naciśnięciu dowolnego klawisza, przy zaznaczonym komponencie nameField. */
			
			public void onKeyUp(KeyUpEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					sendNameToServer();
				}
			}

			 /** Wysyłamy wiadomość na serwer. */
			private void sendNameToServer() {
				// Najpierw, sprawdzamy poprawność wprowadzonej treści.
				errorLabel.setText("");
				String textToServer = nameField.getText();
				if (!FieldVerifier.isValidName(textToServer)) {
					errorLabel.setText("Proszę wprowadzić przynajmniej 4 znaki");
					return;
				}

				// Następnie wysyłamy wprowadzone treści na serwer.
				sendButton.setEnabled(false);
				textToServerLabel.setText(textToServer);
				serverResponseLabel.setText("");
				greetingService.greetServer(textToServer,
						new AsyncCallback<String>() {
							public void onFailure(Throwable caught) {
								// Wyświetlamy komunikat o błędzie RPC.
								dialogBox
										.setText("RPC - Błąd!");
								serverResponseLabel
										.addStyleName("serverResponseLabelError");
								serverResponseLabel.setHTML(SERVER_ERROR);
								dialogBox.center();
								closeButton.setFocus(true);
							}

							public void onSuccess(String result) {
								dialogBox.setText("RPC - zdalne wywołanie procedury");
								serverResponseLabel
										.removeStyleName("serverResponseLabelError");
								serverResponseLabel.setHTML(result);
								dialogBox.center();
								closeButton.setFocus(true);
							}
						});
			}
		}

		// Dodaje handler, który wysyła wprowadzony nick na serwer
		MyHandler handler = new MyHandler();
		sendButton.addClickHandler(handler);
		nameField.addKeyUpHandler(handler);
	}
}
